# video_start_local.py
import json, subprocess, sys, datetime, os
from zoneinfo import ZoneInfo

def ffprobe(path):
    cmd = [
        "ffprobe","-v","error",
        "-print_format","json",
        "-show_format","-show_streams", path
    ]
    out = subprocess.check_output(cmd, text=True)
    return json.loads(out)

def parse_creation_time(meta):
    # Prefer container format.tags.creation_time (UTC ISO8601)
    fmt = meta.get("format", {})
    tags = fmt.get("tags", {}) if fmt else {}
    ct = tags.get("creation_time") or tags.get("com.apple.quicktime.creationdate")
    return ct

def main(path):
    meta = ffprobe(path)
    ct = parse_creation_time(meta)
    if not ct:
        print("No creation_time tag found.")
        sys.exit(1)
    # Normalize: strip timezone if present and parse
    dt_utc = datetime.datetime.fromisoformat(ct.replace("Z","+00:00")).astimezone(ZoneInfo("UTC"))
    # Convert to America/Toronto for display
    local = dt_utc.astimezone(ZoneInfo("America/Toronto"))
    # Show simple hh:mm:ss for your request, plus the full timestamp for auditing
    print("Local start (hh:mm:ss):", local.strftime("%H:%M:%S"))
    print("Local start (full):", local.strftime("%Y-%m-%d %H:%M:%S %Z"))
    print("UTC start (full):  ", dt_utc.strftime("%Y-%m-%d %H:%M:%S %Z"))

if __name__ == "__main__":
    main(sys.argv[1])
