# sidebyside_video_compare.py
import cv2

# --- SETTINGS ---
video1_path = 'camera_1080p.mp4'  # High-res video
video2_path = 'radio_720p.mp4'    # Lower-res video

window_scale = (640, 360)  # Resize both videos to this resolution for comparison

# --- LOAD VIDEOS ---
cap1 = cv2.VideoCapture(video1_path)
cap2 = cv2.VideoCapture(video2_path)

frame_num = 0

while True:
    ret1, frame1 = cap1.read()
    ret2, frame2 = cap2.read()

    if not ret1 or not ret2:
        print("End of one or both videos.")
        break

    # Resize both frames to same dimensions
    frame1_resized = cv2.resize(frame1, window_scale)
    frame2_resized = cv2.resize(frame2, window_scale)

    # Generate visual difference
    diff = cv2.absdiff(frame1_resized, frame2_resized)
    diff_gray = cv2.cvtColor(diff, cv2.COLOR_BGR2GRAY)
    diff_color = cv2.cvtColor(diff_gray, cv2.COLOR_GRAY2BGR)

    # Combine into one image: [cam][radio][diff]
    combined = cv2.hconcat([frame1_resized, frame2_resized, diff_color])

    # Add frame number overlay
    cv2.putText(combined, f"Frame: {frame_num}", (10, 25),
                cv2.FONT_HERSHEY_SIMPLEX, 0.7, (0, 255, 255), 2)

    # Display
    cv2.imshow('Comparison: [Camera 1080p | Radio 720p | Diff]', combined)

    key = cv2.waitKey(0)  # Wait for key to advance frame
    if key == ord('q') or key == 27:  # 'q' or ESC to quit
        break
    elif key == ord('s'):
        # Save current frames for external review
        cv2.imwrite(f'frame_{frame_num:04}_cam.jpg', frame1_resized)
        cv2.imwrite(f'frame_{frame_num:04}_radio.jpg', frame2_resized)
        cv2.imwrite(f'frame_{frame_num:04}_diff.jpg', diff_color)
        print(f"Saved frame {frame_num}")

    frame_num += 1

# Cleanup
cap1.release()
cap2.release()
cv2.destroyAllWindows()
