# media_slideshow_gui_v3
import os
import glob
import webbrowser
import tkinter as tk
from tkinter import filedialog, messagebox

def generate_slideshow_html(media_dir, html_output_path):
    # Find images and videos
    supported_ext = ('*.jpg', '*.jpeg', '*.png', '*.gif', '*.mp4', '*.webm')
    files = []
    for ext in supported_ext:
        files.extend(glob.glob(os.path.join(media_dir, ext)))
    files.sort()

    if not files:
        messagebox.showerror("Error", f"No supported media found in {media_dir}")
        return

    # Escape file paths for HTML/JS
    files_js = [f.replace("\\", "/") for f in files]

    html_content = f"""
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Slideshow</title>
<style>
    html, body {{
        margin: 0;
        height: 100%;
        background: black;
        overflow: hidden;
    }}
    .slideshow {{
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100%;
    }}
    img, video {{
        max-width: 100%;
        max-height: 100%;
        object-fit: contain;
    }}
</style>
</head>
<body>
<div class="slideshow">
    <img id="slide" src="{files_js[0]}" style="display:block;">
    <video id="video" controls style="display:none;"></video>
</div>
<script>
    const files = {files_js};
    let index = 0;
    const img = document.getElementById('slide');
    const vid = document.getElementById('video');

    function showFile(i) {{
        const file = files[i];
        if (file.match(/\\.mp4$/i) || file.match(/\\.webm$/i)) {{
            img.style.display = 'none';
            vid.style.display = 'block';
            vid.src = file;
            vid.play();
        }} else {{
            vid.pause();
            vid.style.display = 'none';
            img.style.display = 'block';
            img.src = file;
        }}
    }}

    document.addEventListener('keydown', function(e) {{
        if (e.key === 'ArrowRight') {{
            index = (index + 1) % files.length;
            showFile(index);
        }} else if (e.key === 'ArrowLeft') {{
            index = (index - 1 + files.length) % files.length;
            showFile(index);
        }} else if (e.key === 'Escape') {{
            window.close();
        }}
    }});
</script>
</body>
</html>
"""

    with open(html_output_path, "w", encoding="utf-8") as f:
        f.write(html_content)

    # Try to open in Chrome, fallback to default browser
    try:
        chrome_path = "C:/Program Files/Google/Chrome/Application/chrome.exe %s"
        webbrowser.get(chrome_path).open(html_output_path)
    except:
        webbrowser.open(html_output_path)

def main():
    root = tk.Tk()
    root.withdraw()

    media_dir = filedialog.askdirectory(title="Select Media Folder")
    if not media_dir:
        return

    default_name = "slideshow.html"
    html_output_path = filedialog.asksaveasfilename(
        title="Save HTML Slideshow As",
        initialdir=media_dir,
        initialfile=default_name,
        defaultextension=".html",
        filetypes=[("HTML files", "*.html")]
    )
    if not html_output_path:
        return

    generate_slideshow_html(media_dir, html_output_path)

if __name__ == "__main__":
    main()
