# gui_toolkit_demo.py

import tkinter as tk
from tkinter import ttk, filedialog, messagebox

# ------------------- Configurable Constants -------------------
DEFAULT_FONT = ("Segoe UI", 10)
DEFAULT_PADX = 10
DEFAULT_PADY = 5

# ------------------- Toolkit Base Window -------------------
def create_base_window(title="Toolkit Demo", size="500x400"):
    root = tk.Tk()
    root.title(title)
    root.geometry(size)
    root.configure(bg="#f5f5f5")

    style = ttk.Style(root)
    style.theme_use("clam")
    style.configure(".", font=DEFAULT_FONT)
    return root

# ------------------- File Dialog Utilities -------------------
def open_file_dialog():
    filepath = filedialog.askopenfilename(
        title="Open File",
        filetypes=[("Text files", "*.txt"), ("All files", "*.*")]
    )
    if filepath:
        print(f"Selected file: {filepath}")
    else:
        print("No file selected")

def save_file_dialog():
    filepath = filedialog.asksaveasfilename(
        title="Save File",
        defaultextension=".txt",
        filetypes=[("Text files", "*.txt"), ("All files", "*.*")]
    )
    if filepath:
        print(f"Save to: {filepath}")
    else:
        print("Save canceled")

# ------------------- Input Form (Text, Number, Time) -------------------
def create_input_form(parent):
    frame = ttk.LabelFrame(parent, text="Input Form")
    frame.pack(fill="x", padx=DEFAULT_PADX, pady=DEFAULT_PADY)

    # Text Input
    ttk.Label(frame, text="Text Input:").grid(row=0, column=0, sticky="w", padx=5, pady=2)
    text_entry = ttk.Entry(frame)
    text_entry.grid(row=0, column=1, sticky="ew", padx=5)

    # Number Input
    ttk.Label(frame, text="Number Input:").grid(row=1, column=0, sticky="w", padx=5, pady=2)
    number_entry = ttk.Entry(frame)
    number_entry.grid(row=1, column=1, sticky="ew", padx=5)

    # Time Input (HH:MM format)
    ttk.Label(frame, text="Time Input (HH:MM):").grid(row=2, column=0, sticky="w", padx=5, pady=2)
    time_entry = ttk.Entry(frame)
    time_entry.grid(row=2, column=1, sticky="ew", padx=5)

    # Submit Button
    def on_submit():
        text = text_entry.get()
        number = number_entry.get()
        time = time_entry.get()
        print("Submitted Data:")
        print(f"Text: {text}")
        print(f"Number: {number}")
        print(f"Time: {time}")

    submit_btn = ttk.Button(frame, text="Submit", command=on_submit)
    submit_btn.grid(row=3, column=0, columnspan=2, pady=10)

    frame.columnconfigure(1, weight=1)

# ------------------- Main Script -------------------
if __name__ == "__main__":
    root = create_base_window()

    # File Dialog Buttons
    btn_frame = ttk.Frame(root)
    btn_frame.pack(fill="x", padx=DEFAULT_PADX, pady=DEFAULT_PADY)

    ttk.Button(btn_frame, text="Open File", command=open_file_dialog).pack(side="left", padx=5)
    ttk.Button(btn_frame, text="Save File", command=save_file_dialog).pack(side="left", padx=5)

    # Add input form
    create_input_form(root)

    root.mainloop()
