# frameatatime_sidebyside_vdeo2.py
import cv2
import numpy as np

video1_path = 'video1.mp4'
video2_path = 'video2.mp4'

cap1 = cv2.VideoCapture(video1_path)
cap2 = cv2.VideoCapture(video2_path)

frame_count1 = int(cap1.get(cv2.CAP_PROP_FRAME_COUNT))
frame_count2 = int(cap2.get(cv2.CAP_PROP_FRAME_COUNT))
total_frames = min(frame_count1, frame_count2)

frame_index = 0

def get_frame(cap, idx):
    cap.set(cv2.CAP_PROP_POS_FRAMES, idx)
    ret, frame = cap.read()
    return frame if ret else None

while True:
    frame1 = get_frame(cap1, frame_index)
    frame2 = get_frame(cap2, frame_index)

    if frame1 is None or frame2 is None:
        print(f"Could not read frame {frame_index}")
        break

    # Resize to match
    if frame1.shape != frame2.shape:
        height = min(frame1.shape[0], frame2.shape[0])
        width = min(frame1.shape[1], frame2.shape[1])
        frame1 = cv2.resize(frame1, (width, height))
        frame2 = cv2.resize(frame2, (width, height))

    # Combine side by side
    combined = np.hstack((frame1, frame2))

    # Draw frame number
    label = f"Frame {frame_index + 1} / {total_frames}"
    cv2.putText(combined, label, (10, 30), cv2.FONT_HERSHEY_SIMPLEX, 1, (0, 255, 255), 2)

    # Show
    cv2.imshow("Side-by-Side Frame Comparison", combined)

    key = cv2.waitKey(0) & 0xFF

    if key == ord('q'):
        break
    elif key == 81 or key == ord('a'):  # Left arrow or 'a'
        if frame_index > 0:
            frame_index -= 1
    elif key == 83 or key == ord('d'):  # Right arrow or 'd'
        if frame_index < total_frames - 1:
            frame_index += 1

cap1.release()
cap2.release()
cv2.destroyAllWindows()
