# frameatatime_sidebyside_vdeo.py
import cv2

# Load the two videos
video1_path = 'video1.mp4'
video2_path = 'video2.mp4'

cap1 = cv2.VideoCapture(video1_path)
cap2 = cv2.VideoCapture(video2_path)

# Check both videos opened successfully
if not cap1.isOpened() or not cap2.isOpened():
    print("Error opening one or both videos.")
    cap1.release()
    cap2.release()
    exit()

scale_width = 1280  # Adjust display width

while True:
    ret1, frame1 = cap1.read()
    ret2, frame2 = cap2.read()

    if not ret1 or not ret2:
        print("End of one or both videos.")
        break

    # Resize frames to same height (if needed)
    height = 480
    frame1 = cv2.resize(frame1, (int(frame1.shape[1] * height / frame1.shape[0]), height))
    frame2 = cv2.resize(frame2, (int(frame2.shape[1] * height / frame2.shape[0]), height))

    # Combine side by side
    combined = cv2.hconcat([frame1, frame2])

    # Optional: resize to fit screen
    if combined.shape[1] > scale_width:
        scale = scale_width / combined.shape[1]
        combined = cv2.resize(combined, (0, 0), fx=scale, fy=scale)

    # Show combined frame
    cv2.imshow('Frame Comparison (Press any key for next, q to quit)', combined)

    key = cv2.waitKey(0)  # Wait for key press
    if key == ord('q'):
        break

# Cleanup
cap1.release()
cap2.release()
cv2.destroyAllWindows()
