# ffmpeg_audio_boost.py
#  avoids moviepy issue with very new pythin version 31Aug 2025
import os
import subprocess
import tkinter as tk
from tkinter import filedialog, messagebox, ttk

def boost_audio():
    input_path = file_var.get()
    try:
        gain_db = float(gain_var.get())
    except ValueError:
        messagebox.showerror("Invalid input", "Gain must be a number.")
        return

    if not input_path or not os.path.isfile(input_path):
        messagebox.showerror("File Error", "Please select a valid video file.")
        return

    base, ext = os.path.splitext(input_path)
    suffix = suffix_var.get().strip() or f"_{int(gain_db)}db"
    output_path = f"{base}{suffix}{ext}"

    cmd = [
        "ffmpeg",
        "-i", input_path,
        "-vcodec", "copy",
        "-af", f"volume={gain_db}dB",
        output_path
    ]

    try:
        subprocess.run(cmd, check=True)
        messagebox.showinfo("Success", f"Audio boosted and saved to:\n{output_path}")
    except subprocess.CalledProcessError as e:
        messagebox.showerror("FFmpeg Error", f"Failed to process video.\n{e}")

def browse_file():
    path = filedialog.askopenfilename(
        filetypes=[("Video files", "*.mp4 *.mov *.avi *.mkv"), ("All files", "*.*")]
    )
    if path:
        file_var.set(path)

# --- GUI Setup ---
root = tk.Tk()
root.title("Boost Audio in Video (FFmpeg)")

tk.Label(root, text="Video File:").grid(row=0, column=0, sticky="e")
file_var = tk.StringVar()
tk.Entry(root, textvariable=file_var, width=40).grid(row=0, column=1)
tk.Button(root, text="Browse", command=browse_file).grid(row=0, column=2)

tk.Label(root, text="Gain (dB):").grid(row=1, column=0, sticky="e")
gain_var = tk.StringVar(value="10")
tk.Entry(root, textvariable=gain_var).grid(row=1, column=1, sticky="we")

tk.Label(root, text="Output Suffix:").grid(row=2, column=0, sticky="e")
suffix_var = tk.StringVar(value="_10db")
tk.Entry(root, textvariable=suffix_var).grid(row=2, column=1, sticky="we")

tk.Button(root, text="Boost Audio", command=boost_audio).grid(row=3, column=0, columnspan=3, pady=10)

root.mainloop()
