# boost_audio_commandline.py
from moviepy.editor import VideoFileClip

def boost_audio(input_path, output_path, gain_dB=15):
    # Load video
    video = VideoFileClip(input_path)
    
    # Boost audio volume
    if video.audio:
        boosted_audio = video.audio.volumex(10 ** (gain_dB / 20))
        video = video.set_audio(boosted_audio)
    else:
        print("No audio track found in the video.")
        return

    # Write output file
    video.write_videofile(output_path, codec="libx264", audio_codec="aac")

# Example usage
boost_audio("airunit_clip.mp4", "boosted_clip.mp4", gain_dB=15)
