import tkinter as tk
from tkinter import filedialog, messagebox
from moviepy.editor import VideoFileClip
import os

def amplify_audio():
    filepath = file_path.get()
    try:
        db_gain = float(gain_db.get())
    except ValueError:
        messagebox.showerror("Invalid input", "Gain must be a number.")
        return

    suffix = suffix_str.get().strip()
    if not suffix:
        suffix = f"_{int(db_gain)}db"

    if not filepath or not os.path.isfile(filepath):
        messagebox.showerror("File error", "Please select a valid video file.")
        return

    try:
        clip = VideoFileClip(filepath)
        factor = 10 ** (db_gain / 20)  # Convert dB to linear gain
        amplified = clip.volumex(factor)

        base, ext = os.path.splitext(filepath)
        output_file = base + suffix + ext

        amplified.write_videofile(output_file, audio_codec="aac")
        messagebox.showinfo("Done", f"Saved: {output_file}")
    except Exception as e:
        messagebox.showerror("Error", str(e))

def select_file():
    path = filedialog.askopenfilename(filetypes=[("Video files", "*.mp4 *.mov *.avi *.mkv")])
    if path:
        file_path.set(path)

# GUI setup
root = tk.Tk()
root.title("Amplify Video Audio")

file_path = tk.StringVar()
gain_db = tk.StringVar(value="10")
suffix_str = tk.StringVar(value="_10db")

tk.Label(root, text="Select video file:").grid(row=0, column=0, sticky="e")
tk.Entry(root, textvariable=file_path, width=40).grid(row=0, column=1)
tk.Button(root, text="Browse...", command=select_file).grid(row=0, column=2)

tk.Label(root, text="Gain (dB):").grid(row=1, column=0, sticky="e")
tk.Entry(root, textvariable=gain_db).grid(row=1, column=1)

tk.Label(root, text="Output suffix:").grid(row=2, column=0, sticky="e")
tk.Entry(root, textvariable=suffix_str).grid(row=2, column=1)

tk.Button(root, text="Amplify Audio", command=amplify_audio).grid(row=3, column=1, pady=10)

root.mainloop()
